/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.spawning.SpawnTypeBlockBreak;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnTypeRock
extends SpawnTypeBlockBreak {
    public int blockBreakRadius = 1;

    public SpawnTypeRock(String typeName) {
        super(typeName);
    }

    @Override
    public void loadFromConfig() {
        super.loadFromConfig();
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        this.blockBreakRadius = config.getInt("Spawner Features", "Rock Spawn Block Break Radius", this.blockBreakRadius, "The block breaking radius aroud a mob spawned from the Rock Spawner.");
    }

    @Override
    public boolean validBlockHarvest(Block block, World world, BlockPos pos, Entity entity) {
        if (!super.validBlockHarvest(block, world, pos, entity)) {
            return false;
        }
        String blockName = block.func_149739_a();
        String[] blockNameParts = blockName.split("\\.");
        boolean isOre = false;
        for (String blockNamePart : blockNameParts) {
            int blockNamePartLength = blockNamePart.length();
            if (blockNamePartLength < 3 || !blockNamePart.substring(0, 3).equalsIgnoreCase("ore") && !blockNamePart.substring(blockNamePartLength - 3, blockNamePartLength).equalsIgnoreCase("ore")) continue;
            isOre = true;
            break;
        }
        return isOre || block == Blocks.field_150418_aU;
    }

    @Override
    public boolean isRareBlock(Block block) {
        if (block == Blocks.field_150482_ag) {
            return true;
        }
        return block == Blocks.field_150412_bA;
    }

    @Override
    public boolean canSpawn(long tick, World world, BlockPos pos, int rank) {
        ExtendedWorld worldExt;
        double roll = world.field_73012_v.nextDouble();
        if (rank > 0) {
            roll /= 4.0;
        }
        if ((worldExt = ExtendedWorld.getForWorld(world)) != null && "boulderdash".equalsIgnoreCase(worldExt.getWorldEventType())) {
            roll /= 4.0;
        }
        return !(roll >= this.chance);
    }

    @Override
    public List<BlockPos> orderCoords(List<BlockPos> coords, BlockPos pos) {
        return this.orderCoordsCloseToFar(coords, pos);
    }

    @Override
    public void spawnEntity(World world, EntityLiving entityLiving, int rank) {
        super.spawnEntity(world, entityLiving, rank);
        if (entityLiving instanceof EntityCreatureBase && this.blockBreakRadius > -1) {
            ((EntityCreatureBase)entityLiving).destroyArea((int)entityLiving.field_70165_t, (int)entityLiving.field_70163_u, (int)entityLiving.field_70161_v, 4.0f, true, this.blockBreakRadius);
        }
    }
}

